class XCrade extends HealthVial;

#exec TEXTURE IMPORT NAME=crade FILE=Textures\crade.bmp Group=Crades MIPS=ON
#exec TEXTURE IMPORT NAME=crade2 FILE=Textures\crade2.bmp Group=Crades MIPS=ON
#exec TEXTURE IMPORT NAME=crade3 FILE=Textures\crade3.bmp Group=Crades MIPS=ON
#exec TEXTURE IMPORT NAME=crade4 FILE=Textures\crade4.bmp Group=Crades MIPS=ON

#exec mesh import mesh=XCrade anivfile=Models\XCrade_a.3d datafile=Models\XCrade_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=XCrade x=0 y=0 z=0
#exec mesh sequence mesh=XCrade seq=All startframe=0 numframes=1
#exec meshmap new meshmap=XCrade mesh=XCrade
#exec meshmap scale meshmap=XCrade x=0.09375 y=0.09375 z=0.18750

event float BotDesireability(Pawn Bot)
{
	return (0); 
}

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

auto state Pickup
{	
function Touch( actor Other )
	{
	if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
		{	
		SetRespawn();
		}
	}
}

defaultproperties
{
     HealingAmount=0
     bSuperHeal=False
     PickupMessage="You picked up a XCrade"
     ItemName="XCrade"
     RespawnTime=0.000000
     PickupViewMesh=Mesh'MHXv3.XCrade'
     Mesh=Mesh'MHXv3.XCrade'
     bCollideWhenPlacing=True
     MultiSkins(0)=Texture'MHXv3.Crades.crade'
     CollisionRadius=24.000000
     CollisionHeight=24.000000
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
}
